' "World's End!"
' Created with QDK Pro 4.0.5

!include <stdverbs.lib>

define game <World's End!>
	asl-version <400>
	gametype singleplayer
	start <hometown>
	game author <GAMER!>
	game version <1.0>
	game info <Created with QDK Pro 4.03>
	startscript {
		msg <Name?>
		enter <name>
		set string <heatville; locked>
		set string <sleepville; locked>
		set string <awakeville; locked>
		flag on <operations room enemys>
		set string <security; on>
		set string <bloodbath city; locked>
		set string <corpse; 0>
		set numeric <statue; 0>
		set string <space suit; zipped>
		flag on <cable undescovered>
		set string <space suit2; not worn>
		set string <parachute; not worn>
		set numeric <junk; 0>
		set numeric <cube health; 10>
		set string <dumbville; locked>
		set string <guardcorpse; 0>
		set string <clayshape; ball>
		set string <darkness; locked>
	}
	beforesave move <saveobject; #quest.currentroom#>
	onload {
		msg <Welcome back!>
		goto <$locationof(saveobject)$>
	}
	command <objects> msg <There is: #quest.formatobjects# here.>
	command <compass> msg <You can go: #quest.doorways.dirs#>
	command <places> msg <You can go: #quest.doorways.places#>
	command <teleport> msg <You can't teleport here.>
	command <sleep> msg <You aren't in the mood.>
	command <give #@object# now> give <#@object#>
	command <interactable #@object#> show <#@object#>
	command <move #@object# here> move <#@object#; #quest.currentroom#>
	command <want> {
		msg <What do you want?>
		enter <want>
		show <#want#>
		give <#want#>
	}
	command <unzip space suit> doaction <space suit; unzip>
	command <mold clay> {
		if got <clay> then {
			msg <You mold the clay into a triangle shape.>
			set string <clayshape; triangle> } else msg <You don't have that.>
	}
	command <walkthrough> 
	verb <examine> msg <You can't examine that.>
	define variable <health>
		type numeric
		value <100>
		display <You have ! health>
		onchange {
			if ( %health% <= 0 ) then {
				playwav <die.wav>
				playerlose
				timeroff <cube> }
		}
	end define
	define variable <money>
		type numeric
		value <5>
		display <You have ! gold dollars>
	end define
	define variable <chiefhealth>
		type numeric
		value <0>
		display nozero <The leader of the aliens has ! health.>
	end define
end define

define options
	debug on
	panes on
	abbreviations on
end define

define synonyms
	pole = flag pole
	open a manhole; open the manhole; open manhole cover; open a manhole cover; open the manhole cover = open manhole
	shoot = use smg on
	shoot = use laser pistol on
	space; suit; s = space suit
end define

define room <hometown>
	north <lazer gun shop>
	east <teleport stand>
	description <This is the town where you grew up in and where you still live. It's just a normal town with shops and stuff. To the east is a teleport station. There is a laser gun shop to the north. There is a huge statue in the middle of the town on a huge plinth. To the west are the gates where guards are only letting people through who have a pass.>
	command <stand on plinth> msg <You stand on the plinth and nothing happens.>
	command <climb statue> msg <No point climbing the statue.>

	define object <statue>
		look <This statue is of a man holding a laser riffle. The statue is standing on a marble plinth.>
		speak {
			msg <You feel like doing something dumb so you talk to the statue. Suddenly a cat bounds up to you!>
			show <cat>
			action <statue; speak> msg <It says nothing.>
		}
		prefix <a huge>
		displaytype <Object>
		article <it>
		gender <it>
		properties <examine=>
	end define

	define object <plinth>
		look <It's a marble plinth. On it there is a tall statue.>
		prefix <a marble>
		displaytype <Object>
		article <it>
		gender <it>
		use <smg> {
			msg <You shoot the plinth. It shatters and the statue falls down a hole. A security chip rolls across the ground.>
			show <heatville chip>
			playwav <smg single shot.wav>
		}
		action <shoot> msg <>
	end define

	define object <heatville chip>
		alias <security chip>
		look <It's a security chip. You can use it to unlock a place.>
		take
		prefix <a>
		displaytype <Object>
		article <it>
		gender <it>
		hidden
		drop nowhere <You might need this.>
	end define

	define object <cat>
		look <It's a cat.>
		take
		prefix <a>
		displaytype <Object>
		article <it>
		gender <it>
		hidden
		drop everywhere <You let it go.>
	end define

end define

define room <teleport stand>
	west <hometown>
	description <This is a teleport stand. It's name says it all. People are teleporting around. A notice reads "just type teleport.">
	command <teleport> choose <teleport>

	define object <device>
		look <It's a device used to unlock new places.>
		prefix <a>
		displaytype <Object>
		article <it>
		gender <it>
		use <heatville chip> {
			msg <You insert the chip. There is a wering from the teleporter.>
			hide <heatville chip>
			set string <heatville; heatville>
		}
		use <sleepville chip> {
			msg <You insert the security chip.>
			hide <sleepville chip>
			set string <sleepville; sleepville>
		}
		use <awakeville chip> {
			msg <You insert the security chip.>
			hide <awakeville chip>
			set string <awakeville; awakeville>
		}
		use <bloodbath city chip> {
			msg <You insert the security chip.>
			hide <bloodbath city chip>
			set string <bloodbath city; bloodbath city>
		}
		use <dumbville chip> {
			msg <You insert the security chip.>
			hide <dumbville chip>
			set string <dumbville; dumbville>
		}
		use <darkness chip> {
			msg <You insert the security chip. The teleporter rumbles ominously!>
			hide <darkness chip>
			set string <darkness; alien's location>
		}
		properties <examine=Written on the side of it is "insert chip.";examine=Written on the side of it is "insert chip.">
	end define

end define

define room <snowville>
	place <ice forest>
	description <This is the ice town. Snowmen are on top of buildings. There is a huge snow statue lying on the floor. There is a huge flag pole stuck in a circle of ice that should be a pond.>
	command <climb flag pole> {
		msg <You aren't the best climber. You try it anyway. You fall halfway up and lose 10 health!>
		dec <health; 10>
	}
	command <teleport> goto <teleport stand>

	define object <ice statue>
		look <This statue is lying on the floor.>
		prefix <an>
		displaytype <Object>
		article <it>
		gender <it>
		use <smg> {
			if flag <diamond> then {
				msg <You shoot the statue. After about 7 shots the statue's head falls off revealing a diamond!>
				show <diamond>
				playwav <smg short burst.wav> } else msg <No point shooting that.>
		}
	end define

	define object <flag pole>
		look <This flag pole is wedged in the ice in a circle of ice that should be a pond.>
		prefix <a>
		displaytype <Object>
		article <it>
		gender <it>
		use <smg> {
			msg <You shoot the pole but it doesn't fall.>
			playwav <smg short burst.wav>
		}
		use <axe> {
			msg <You chop down the flag pole.>
			hide <flag pole>
			show <pole>
		}
	end define

	define object <questgiver1>
		alias <woman>
		look <Just a person.>
		speak {
			msg <"My cat's gon missing! If you find him I'll give you 20 gold dollars.">
			if ask <Will you find the woman's cat?> then {
				msg <"Great.">
				action <questgiver1; speak> msg <"Have you found my cat yet?"> } else {
				msg <"Oh well."|nShe walks away.>
				hide <questgiver1> }
		}
		prefix <a>
		displaytype <Character>
		article <her>
		gender <she>
		give <cat> {
			msg <You give the cat to the woman.|n "Thanks. Here's your 20 gold dollars.">
			hide <cat>
			hide <questgiver1>
			inc <money; 20>
		}
		properties <examine=She is holding an empty basket.;examine=She is holding an empty basket.>
	end define

	define object <diamond>
		look <It's a diamond!>
		take
		prefix <a>
		displaytype <Object>
		article <it>
		gender <it>
		hidden
		drop nowhere <You might need it!>
	end define

	define object <pole>
		look <Just a long pole.>
		take
		prefix <a long>
		displaytype <Object>
		article <it>
		gender <it>
		hidden
	end define

end define

define room <lazer gun shop>
	alias <gun shop>
	south <hometown>
	script msg <The man behind the counter looks up as you enter.>
	description <This is a lazer gun shop. It also sells normal guns like "smg's." There are loads of guns on display here.>

	define object <gun seller>
		look <He's the gun seller.>
		speak choose <guns select>
		prefix <the>
		displaytype <Character>
		article <him>
		gender <he>
	end define

	define object <smg>
		take
		displaytype <Object>
		article <it>
		gender <it>
		hidden
		use on anything msg <No point shooting that.>
		drop nowhere <You might need it.>
	end define

	define object <laser pistol>
		look <It's a laser pistol.>
		take
		prefix <a>
		displaytype <Object>
		article <it>
		gender <it>
		hidden
		drop nowhere <You might need it.>
	end define

end define

define room <heatville>
	north if not exists <questgiver2> then goto <fields> else msg <There is a gate blocking your path to the north.>
	place <the; night club>
	script playwav <>
	description <This town is boiling! People are sunbathing everywhere. There is an icecream store serving soup. People are drinking coke and water. Just a normal boiling town.>
	command <teleport> goto <teleport stand>

	define object <questgiver2>
		alias <man>
		look <Just a person.>
		speak {
			msg <"Hey can you help me? Some idiot put my diamond into a statue in snowville and I can't get is out. Could you do it for me? If you do I'll give you this knife.">
			if ask <Will you get the diamond?> then {
				msg <"Great.">
				action <questgiver2; speak> msg <"Have you got the diamond yet?">
				flag on <diamond> } else msg <"Come back when you'll find it.">
		}
		prefix <a>
		displaytype <Character>
		article <him>
		gender <he>
		give <diamond> {
			msg <"Thanks. Here's the knife."|nHe Leaves gleefully and slots the diamond into a plinth. You see that a gate has opened to the north revealing some fields.>
			hide <diamond>
			show <knife>
			give <knife>
			hide <questgiver2>
		}
	end define

	define object <knife>
		displaytype <Object>
		article <it>
		gender <it>
		hidden
	end define

	define object <trader>
		alias <salesman>
		look <He's a salesman.>
		speak {
			if ask <"I'll give you this scrrewdriver for 2 gold dollars. Want it?"> then {
				msg <You buy the screwdriver.>
				hide <trader>
				show <screwdriver>
				give <screwdriver> }
		}
		prefix <a>
		displaytype <Character>
		article <him>
		gender <he>
	end define

	define object <screwdriver>
		take
		displaytype <Object>
		article <it>
		gender <it>
		hidden
	end define

end define

define room <fields>
	indescription <You are in a:>
	south <heatville>
	description <These are just normal fields. There is a crop circle in the middle of the fields. There is a small spaceship parked in the middle of the circle.>
	command <get in spaceship> if exists <spaceship> then goto <spaceshiproom> else msg <It kind of exploded.>

	define object <alien1>
		alias <alien>
		look <It's an alies.>
		speak <"ASSASSINATE. ASSASSINATE.">
		prefix <an>
		displaytype <Object>
		article <it>
		gender <it>
		use <smg> {
			msg <You shoot the alien and it dies. You find 30 gold dollars on it.>
			hide <alien1>
			inc <money; 30>
			playwav <smg single shot.wav>
		}
	end define

	define object <alien2>
		alias <alien>
		look <It's an alien.>
		prefix <an>
		displaytype <Object>
		article <it>
		gender <it>
		use <smg> {
			msg <You shoot the alien. It doesn't die. You shoot it 4 more times and it dies. You find a small ice gem on it.>
			hide <alien2>
			playwav <smg short burst.wav>
			show <ice gem>
			give <ice gem>
		}
	end define

	define object <ice gem>
		look <It's an ice gem.>
		prefix <an>
		displaytype <Object>
		article <it>
		gender <it>
		hidden
	end define

	define object <spaceship>
		look <It's a spaceship!>
		prefix <a>
		displaytype <Object>
		article <it>
		gender <it>
		use <dynamite> {
			msg <You plant the dynamite near the spaceship.>
			hide <dynamite>
			show <dynamite2>
		}
		properties <examine=You could get in it.>
	end define

	define object <crop circle>
		look <It's a crop circle!>
		prefix <a>
		displaytype <Object>
		article <it>
		gender <it>
		action <examine> {
			if not exists <spaceship> then {
				msg <You examine the crop circle and see a security chip.>
				show <sleepville chip>
				action <crop circle; examine> msg <You examine the crop circle and find nothing else.> } else msg <You can't examine it because the spaceship is on it.>
		}
	end define

	define object <sleepville chip>
		alias <security chip>
		look <It's a security chip.>
		take
		prefix <a>
		displaytype <Object>
		article <it>
		gender <it>
		hidden
		drop nowhere <You might need it.>
	end define

	define object <dynamite2>
		alias <dynamite>
		look <It's a stick of dynamite.>
		prefix <a stick of>
		displaytype <Object>
		article <it>
		gender <it>
		hidden
		use <lighter> {
			msg <You light the dynamite.>
			timeron <dynamite>
		}
		properties <examine=It's been put near the alien spaceship.>
	end define

end define

define room <ice forest>
	out <snowville>
	north <ice forest camp>
	description <This is an ice forest. There are ice trees everywhere. There is a stone bench with a hole in the top of it. Ice bears kill each other.>

	define object <bench>
		look <It's a stone bench.>
		prefix <a stone>
		displaytype <Object>
		article <it>
		gender <it>
		use <ice gem> {
			msg <You put the gem into the hole. The hole disappears and a tree starts to move! It moves asside revealing an ice chamber beneath.>
			hide <ice gem>
			create exit down <ice forest; ice chamber>
			create exit up <ice chamber; ice forest>
			action <bench; examine> msg <The hole has dissappeared. It's just a normal bench.>
		}
		properties <examine=There is a hole in the top of it.>
	end define

	define object <trees>
		look <There are ice trees everywhere.>
		prefix <loads of>
		displaytype <Object>
		article <them>
		gender <they>
	end define

end define

define room <ice chamber>
	description <This is a huge chamber. There is nothing really in here except for a huge book hanging from a rope.>
	command <read book> msg <There is nothing written in the book.>

	define object <book>
		look <This book is hanging from the ceiling on a rope.>
		prefix <a>
		displaytype <Object>
		article <it>
		gender <it>
		use <knife> {
			msg <You cut the book up and find a key!>
			hide <book>
			show <key>
		}
		properties <examine=Just a book.>
	end define

	define object <key>
		alias <silver key>
		look <It's a silver key.>
		take
		prefix <a>
		displaytype <Object>
		article <it>
		gender <it>
		hidden
		drop nowhere <You might need it.>
	end define

end define

define room <spaceshiproom>
	alias <spaceship>
	out <fields>
	description <This is a spaceship. There are machines everywhere. There is a cupboard on the wall.>

	define object <cupboard>
		look <It's a cupboard.>
		prefix <a>
		displaytype <Object>
		article <it>
		gender <it>
		use <key> {
			msg <You slide the key into the lock on the cupboard and it opens revealing a stick of dynamite!>
			hide <cupboard>
			show <dynamite>
		}
		properties <examine=The door of it is locked.>
	end define

	define object <dynamite>
		look <It's a stick on dynamite.>
		take
		prefix <a stick of>
		displaytype <Object>
		article <it>
		gender <it>
		hidden
		drop nowhere <You might need it.>
	end define

	define object <machines>
		look <There are machines everywhere.>
		displaytype <Object>
		article <it>
		gender <it>
		use <smg> {
			msg <You shoot the machines.>
			playwav <smg long burst.wav>
			hide <machines>
		}
	end define

end define

define room <night club>
	out <heatville>
	script playwav <night club.wav; loop>
	description <This is a normal night club. Music is blearing from speakers everywhere.>

	define object <drunk alien>
		look <Uh oh! It's a drunk alien!>
		speak {
			msg <"I'm gonna shoot you!"|nIt does!>
			playerlose
		}
		prefix <a>
		displaytype <Object>
		article <it>
		gender <it>
		use <smg> {
			msg <You shoot the alien.>
			playwav <smg single shot.wav; sync>
			hide <drunk alien>
			show <lighter>
		}
	end define

	define object <lighter>
		take <You pick up the lighter.>
		displaytype <Object>
		article <it>
		gender <it>
		hidden
		drop nowhere <You might need it.>
	end define

	define object <guitar>
		look <It's a guitar.>
		take
		prefix <a>
		displaytype <Object>
		article <it>
		gender <it>
		use <knife> {
			msg <You cut the strings on the guitar and find a teleporter inside it!>
			hide <guitar>
			show <teleporter>
			give <teleporter>
		}
		drop nowhere <You might need it.>
	end define

	define object <bartender>
		look <He's a bartender dressed in a long white robe.>
		speak <"Go away.">
		prefix <a>
		displaytype <Character>
		article <him>
		gender <he>
		give <teleporter> {
			msg <You give the teleporter to the bartender. He gives you a normal axe.>
			hide <teleporter>
			hide <bartender>
			show <axe>
			give <axe>
		}
		properties <examine=He is muttering "Lost teleporter. Can't find it.">
	end define

	define object <teleporter>
		alias <teleporter>
		look <It's a standard teleporter.>
		take
		prefix <a>
		displaytype <Object>
		article <it>
		gender <it>
		hidden
		use {
			msg <You teleport and find yourself in an alien base!>
			goto <alienbase1>
		}
		drop nowhere <You might need it.>
	end define

	define object <axe>
		take
		displaytype <Object>
		article <it>
		gender <it>
		hidden
		drop nowhere <You might need it.>
	end define

end define

define room <sleepville>
	description <You are in the town ofo sleepville. People are sleeping in beds in the middle of the street. Bed shops are everywhere.>
	command <teleport> goto <teleport stand>
	command <play guitar> {
		msg <You start playing the guitar. Suddenly a man jumps up and starts shooting you for waking him up! Your lifeless corpse falls down a sewer!>
		playwav <smg long burst.wav>
		playerlose
	}
	command <sleep> msg <You aren't in the mood right now.>

	define object <woman>
		look <She's a woman.>
		speak {
			msg <"HEEEELP! My husband slept to much! He can't wake up! He isn't dead. I checked his pulse. I need someone to wake him up. If you do I'll give you 60 gold dollars!">
			if ask <Will you help her?> then {
				msg <"Thanks.">
				action <woman; speak> msg <"Have you got something to wake him up yet?"> } else msg <"Oh well.">
		}
		prefix <a>
		displaytype <Object>
		article <it>
		gender <it>
	end define

	define object <bed>
		look <Just a bed.>
		prefix <a>
		displaytype <Object>
		article <it>
		gender <it>
		use <knife> msg <You can't prise the screw out with that!1>
		use <screwdriver> {
			msg <You unscrew the screws on the bed. The man falls onto the floor and wakes up!|n "Thanks" the woman says. "Here's 60 gold dollars.">
			inc <money; 60>
			show <screw>
		}
		properties <examine=It's a normal bed. There is a screw sticking out of the top of itt. Maybe you could remove it?>
	end define

	define object <man>
		look <He's a man who is still asleep!>
		speak <"WAKE UP!" you say. It doesn't work!>
		prefix <a>
		displaytype <Character>
		article <him>
		gender <he>
	end define

	define object <screw>
		take
		prefix <a>
		displaytype <Object>
		article <it>
		gender <it>
		hidden
	end define

end define

define room <alienbase1>
	alias <alien base>
	indescription <You are on a:>
	description <This is an alien base! It's like a maze in here! There is an alien working on some kind of cocmputer.>
	command <turn on computer> {
		if exists <basealien1> then msg <You need to kill the alien first.> else {
			msg <You turn on the computer. Suddenly you are teleported! A security chip falls into yor hand and you find yorself in snowville!>
			show <awakeville chip>
			give <awakeville chip>
			goto <snowville> }
	}

	define object <basealien1>
		alias <alien>
		look <It's an alien!>
		prefix <an>
		displaytype <Object>
		article <it>
		gender <it>
		use <smg> {
			msg <1 shot finishes it off.>
			playwav <smg single shot.wav>
			hide <basealien1>
		}
	end define

	define object <computer>
		look <It's a computer.>
		prefix <a>
		displaytype <Object>
		article <it>
		gender <it>
		action <examine> if exists <basealien1> then msg <An alien is using it.> else msg <It's a weird computer.>
	end define

	define object <awakeville chip>
		alias <security chip>
		look <It's a security chip.>
		take
		prefix <a>
		displaytype <Object>
		article <it>
		gender <it>
		drop nowhere <You might need it.>
	end define

end define

define room <awakeville>
	indescription <You are on a:>
	description <You are in the town of awakeville. People are jumping around the place and doing excersises. A person is running around the small town. A person is climbing a tiny pole with no effort! Wow! This town is awake!>
	command <teleport> goto <teleport stand>
	command <open manhole> {
		msg <You open a manhole.>
		create exit down <awakeville; sewer1>
		create exit up <sewer1; awakeville>
	}

	define object <obstacle course>
		look <It's a really long obstacle course!>
		prefix <an>
		displaytype <Object>
		article <it>
		gender <it>
	end define

	define object <questgiver3>
		alias <man>
		look <Just a person.>
		speak {
			msg <"I've lost the family dog. He fell down a drain. Could you go down the sewers and find him? Just "open manhole" to go down the sewers.">
			if ask <Will you help him?> then {
				msg <"Thanks.">
				action <questgiver3; speak> msg <"Have you found the dog yet?"> } else msg <"Oh well.">
		}
		prefix <a>
		displaytype <Character>
		article <him>
		gender <he>
		give <dog> {
			msg <You give the person the dog.|n "Here's your 200 gold dollars.">
			hide <questgiver3>
			hide <dog>
			inc <money; 200>
		}
	end define

end define

define room <sewer1>
	alias <sewer>
	indescription <You are on a:>
	north <sewer2>
	west <sewer3>
	description <This place stinks! It's like a maze down here.>
	command <drown yourself> msg <You don't feel like it right now.>
end define

define room <sewer2>
	alias <sewer>
	indescription <You are on a:>
	south <sewer1>
	east <sewer4>
	west <sewer5>
	description <This place stinks! It's like a maze down here.>
end define

define room <sewer3>
	alias <sewer>
	indescription <You are on a:>
	east <sewer1>
	description <This place stinks! It's like a maze down here.>
end define

define room <sewer4>
	alias <sewer>
	indescription <You are on a:>
	north <sewer5>
	west <sewer2>
	description <This place stinks! It's like a maze down here.>
end define

define room <sewer5>
	alias <sewer>
	indescription <You are on a:>
	south <sewer4>
	east <sewer2>
	script {
		displaytext <captured>
		goto <cell>
	}
	description <This place stinks! It's like a maze down here.>
end define

define room <cell>
	indescription <You are on a:>
	west msg <The cell's door is locked.>
	script msg <>
	description <This is a dingy jail cell. It's so boring in here. There is a door is locked with a card reader on the other side. yor trapped in here obviously. There are no windows. Only a bunk. A chandelier hangs overhead. You wonder what a chandelier is doing in a cell.>

	define object <bunk>
		look <It's a bunk>
		take <You start dragging it around.>
		prefix <a>
		displaytype <Object>
		article <it>
		gender <it>
		use <axe> {
			msg <You chop a leg off the bunk.>
			hide <bunk>
			show <leg>
		}
		drop everywhere <You let go of it.>
	end define

	define object <leg>
		look <It's a leg off the bunk.>
		take
		prefix <a>
		displaytype <Object>
		article <it>
		gender <it>
		hidden
	end define

	define object <chandelier>
		look <It's a chandelier.>
		prefix <a>
		displaytype <Object>
		article <it>
		gender <it>
		use <leg> {
			msg <You hurl the leg at the chandelier. It smashes and glash shards fall everywhere! A grate is revealed in the ceiling.>
			hide <chandelier>
			show <shards>
			show <grate>
			lose <leg>
		}
	end define

	define object <grate>
		look <It's a grate on the ceiling.>
		prefix <a>
		suffix <in the ceiling>
		displaytype <Object>
		article <it>
		gender <it>
		hidden
		use <smg> {
			msg <You shoot the grate. It flies off. It reveals a water pipe.>
			hide <grate>
			show <water pipe>
			playwav <smg single shot.wav>
		}
	end define

	define object <shards>
		look <They are shards of glass from the chandelier.>
		prefix <some>
		suffix <of glass>
		displaytype <Object>
		article <it>
		gender <it>
		hidden
	end define

	define object <water pipe>
		look <This pipe has the word "water" written on it.>
		displaytype <Object>
		article <it>
		gender <it>
		hidden
		use <smg> {
			msg <You shoot the water pipe. Nothing happens. You shoot it 4 times more. The pipe splits and a tidle wave of water pours into the room blowing the door off it's hinges!>
			hide <water pipe>
			create exit west <cell; hallway>
			playwav <smg short burst.wav>
		}
	end define

end define

define room <hallway>
	indescription <You are on a:>
	description <This is a small hallway. Nothing here really. There is a broken-down elevator which is yor ownly means of escape.>

	define object <broken-down elevator>
		look <The elevator has broken down!>
		prefix <a>
		displaytype <Object>
		article <it>
		gender <it>
		use <screw> {
			msg <You fit the screw into the hole in the elevator.>
			hide <screw>
			flag on <screw>
		}
		use <screwdriver> {
			if flag <screw> then {
				msg <You screw in the screw and get in the elevator. You find yourself in a lobby.>
				goto <lobby> } else msg <You need to do something first.>
		}
	end define

end define

define room <lobby>
	south <downstairs hallway>
	west if ( #security# = off ) then goto <courtyard> else msg <The door to the west is locked.>
	description <This is a lobby. An alien guard is guarding the front entrance. A hallway leads south.>

	define object <guard>
		look <It's a guard alien!>
		prefix <a>
		displaytype <Object>
		article <it>
		gender <it>
		use <smg> {
			msg <You shoot the guard but nothing happens! He walks over to you and slowly strangles you to death!>
			playwav <smg short burst.wav>
			playerlose
		}
		use <pole> msg <You whack the guard with the pole. He drops his gun.>
		use <flame thrower> {
			msg <You show the flame thrower to the guard.>
			choose <guard>
		}
		give <flame thrower> msg <You shouldn't give it to him you should to something else to him.>
		properties <examine=He is muttering "Where's my flame thrower?">
	end define

	define object <hole>
		look <It's a hole in the floor.>
		prefix <a>
		suffix <in the floor>
		displaytype <Object>
		article <it>
		gender <it>
		use <pole> {
			msg <You put the pole in the hole. A flame thrower slides down a pipe and onto the floor. You take the pole from the hole. The hole's top closes over.>
			hide <hole>
			show <flame thrower>
		}
		properties <examine=It's circle shape.>
	end define

	define object <flame thrower>
		take
		displaytype <Object>
		article <it>
		gender <it>
		hidden
		use <flame thrower> {
			msg <You show the flame thrower to the guard.|n  "I'll give you anything for the torture device in your hand.">
			choose <guard>
		}
		drop nowhere <You might need it.>
	end define

end define

define room <downstairs hallway>
	north <lobby>
	south <operations room>
	description <This is a short north to south hallway.>

	define object <chest>
		look <It's a large black chest.>
		prefix <a>
		displaytype <Object>
		article <it>
		gender <it>
		use <flame thrower> {
			msg <You burn the chest open revealing the dog the person in awakeville lost!>
			hide <chest>
			show <dog>
		}
		use <axe> {
			msg <You smash open the chest revealing the dog the person in awakeville lost!>
			hide <chest>
			show <dog>
		}
		container
		open msg <The chest is locked.>
		properties <examine=The chest is locked.>
	end define

	define object <dog>
		look <He's the dog the person in awakeville lost.>
		take <YOu take the dog's lead.>
		prefix <a>
		displaytype <Object>
		article <it>
		gender <it>
		hidden
		drop everywhere <You let go of the lead.>
		action <examine> {
			if exists <collar> then msg <There is nothing else on the dog.> else {
				msg <You see that the dog's collar has come loose.>
				show <collar>
				give <collar> }
		}
	end define

	define object <collar>
		look <It's a dog's collar.>
		prefix <a dog>
		displaytype <Object>
		article <it>
		gender <it>
		hidden
		properties <examine=Written on the collar is "arctic mut.">
	end define

end define

define room <operations room>
	indescription <You are on a:>
	north <downstairs hallway>
	script if flag <operations room enemys> then do <operations room enemys>
	description <This is an operations room. Nothing special here.>
	command <turn on computers> {
		msg <What is the password?>
		enter <computers>
		if ( #computers# = bloodbath ) then choose <computers1> else msg <The password was wrong!>
	}

	define object <computers>
		look <There are loads of computers everywhere.>
		displaytype <Object>
		article <it>
		gender <it>
	end define

end define

define room <courtyard>
	indescription <You are on a:>
	north <guardhouse>
	description <This is a courtyard. There is only 1 exit to the north. The door to the east has locked. To the north is a guardhouse.>
end define

define room <guardhouse>
	indescription <You are on a:>
	north if flag <gate open> then goto <road> else msg <The gate is locked.>
	south <courtyard>
	description <This is a guardhouse. A guard is here with a remote in his hand. A device is in his hand.>

	define object <guardhouse guard>
		alias <guard>
		look <You realise he's human!>
		speak {
			msg <"I'll give you this device. Type your password. If it's right this gate will open.">
			if ask <Will you try to guess the password?> then {
				msg <Type the password.>
				enter <guardhouseguard>
				if ( #guardhouseguard# = arctic ) then {
					msg <"You can pass.">
					action <guardhouse guard; speak> msg <"You've already said the password.">
					flag on <gate open> } else {
					msg <"Wrong! I'm gonna kill you now!"|nHe points a laser gun at you and fires!>
					playwav <laser1.wav>
					wait <PUSH A KEY TO FIND OUT WHAT HAPPENS!>
					set numeric <health; 0> } }
		}
		prefix <a>
		displaytype <Character>
		article <him>
		gender <he>
	end define

end define

define room <road>
	look <This is an east to west road. To the east are some gates guarded by guards and there is a manhole cover in the middle of the street. To the west is a huge crator.>
	indescription <You are on a:>
	west msg <There is a huge crator blocking your way west.>
	script action <sewer5; script> msg <There are no zombies this time!>

	define object <crator>
		look <This is a huge crator blocking your path to the west.>
		prefix <a huge>
		displaytype <Object>
		article <it>
		gender <it>
		properties <examine=>
		action <examine> {
			msg <You lean over the edge of the crator and see a glinting object. The guard leaves the guardhouse and pushes you down the crator! You quiklygrab a ledge and climb down to the bottom.>
			goto <crator bottom>
		}
	end define

end define

define room <crator bottom>
	alias <crator>
	indescription <You are in a:>
	up msg <You can't just climb up the walls.>
	description <This is the bottom of a huge crator. There is nothing here really.>
	command <search corpse> {
		if ( #corpse# = 0 ) then {
			msg <You search the corpse and find a teleporter!>
			show <teleporter>
			set string <guardcorpse; 1> } else msg <There's nothing else on the corpse.>
	}

	define object <bloodbath city chip>
		alias <security chip>
		look <It's a security chip.>
		take
		prefix <a>
		displaytype <Object>
		article <it>
		gender <it>
		drop nowhere <You might need it.>
	end define

	define object <light>
		look <It's the light at the top of the crator.>
		displaytype <Object>
		article <it>
		gender <it>
		use <teleporter> {
			msg <You out of pure desperation push the button on the teleporter and point it at the light. You are teleported back to your hometown!>
			goto <hometown>
		}
		use <smg> {
			msg <You fire allot of bullets at the light. There is a scream then the guard falls  towards you. You hurl yourself out of the way as the guard's corpse splats on the floor covering you in blood!>
			show <guardcorpse>
		}
	end define

	define object <guardcorpse>
		alias <corpse>
		look <It's the splatted remains of the corpse of the guard from the guardhouse.>
		prefix <a>
		displaytype <Object>
		article <it>
		gender <it>
		hidden
	end define

end define

define room <bloodbath city>
	indescription <You are in a:>
	description <This is the violent town of bloodbath city. A woman is chopping a cow into billions of pieces! A man's corpse lies on the ground blood pouring out of it's ears. >
	command <search corpse> {
		if ( #corpse# = 0 ) then {
			msg <You search the corpse and find a box.>
			show <box>
			set string <corpse; 1> } else msg <You find nothing else on the corpse.>
	}
	command <teleport> goto <teleport stand>

	define object <corpse>
		look <This corpse is lying on the ground. Blood is pouring from it's ears and staining the tarmac around it.>
		prefix <a>
		displaytype <Object>
		article <it>
		gender <it>
		properties <examine=There is something bulky in his pocket.>
	end define

	define object <questgiver4>
		alias <woman>
		look <Just a violent person with a chain saw.>
		speak {
			msg <"Some swine nicked my glasses. I'll give you a triangle made out of wood for them.">
			if ask <Will you try to find the glasses?> then {
				msg <She doesn't respond.>
				action <questgiver4; speak> msg <"Got them yet?"> }
		}
		prefix <a>
		suffix <chopping up a cow>
		displaytype <Character>
		article <her>
		gender <she>
		give <glasses> {
			msg <You give the glasses to the woman. She gives you a wooden triangle.>
			hide <glasses>
			hide <questgiver4>
			show <triangle2>
			give <triangle2>
		}
		properties <examine=The woman is chopping a cow into billions of pieces.>
	end define

	define object <box>
		look <It's a box.>
		take
		prefix <a>
		displaytype <Object>
		article <it>
		gender <it>
		hidden
		drop everywhere <You place it on the ground.>
		container
		open <You open the box.>
		close <You close the box.>
		add
		remove
	end define

	define object <bloodbath statue>
		alias <statue>
		look <It's a statue.>
		prefix <a>
		displaytype <Object>
		article <it>
		gender <it>
		use <eye> {
			msg <You fit the eye into an empty eyehole.|nSuddenly the statue turns revealing a trap door!>
			hide <eye>
			show <trap door>
		}
	end define

	define object <eye>
		look <It's a small glass eye.>
		take
		prefix <a small>
		displaytype <Object>
		article <it>
		gender <it>
		parent <box>
	end define

	define object <trap door>
		look <It's a trap door.>
		prefix <a>
		displaytype <Object>
		article <it>
		gender <it>
		hidden
		use <laser pistol> {
			msg <You shoot the trap door. It falls into the room below.>
			playwav <laser2.wav>
			create exit down <bloodbath city; lab>
		}
		properties <examine=It is locked.;examine=It is locked.>
	end define

	define object <triangle2>
		alias <triangle>
		look <It's a wooden triangle.>
		take
		prefix <a>
		suffix <made out of wood>
		displaytype <Object>
		article <it>
		gender <it>
		hidden
		drop nowhere <You might need this.>
	end define

end define

define room <lab>
	description {
		msg <You descend into a dark lab. You are thinking you should go and get a flashlight when a light comes on revealing a huge room. A man is aiming a in huge room. A scientist is pointing an uzzi at you!>
		wait <PRESS A KEY TO CONTINUE!>
		msg <I've been expecting you. Now your going to die.>
		goto <lab scientist fight>
	}
end define

define room <lab scientist fight>
	alias <lab>
	look <This is a lab. Benches are everywhere. A vial of something is on the floor.>
	indescription <You are in a:>
	up msg <You can't leave well fighting a scientist trying to kill you!>

	define object <scientist>
		look <A scientist trying to kill you!>
		prefix <a>
		displaytype <Object>
		article <it>
		gender <it>
		use <smg> {
			msg <You shoot him but the bullet bounces off!>
			playwav <smg single shot.wav>
		}
		use <vial> {
			msg <You hurl the vial at the scientist. It hits him. Apparently it was a vial of assid because the assid eats through his armor and he jumps from the assid pool.>
			hide <vial>
			playwav <smash.wav>
			flag on <scientist vonourable>
		}
		use <laser pistol> {
			if flag <scientist vonourable> then {
				msg <You shoot the scientist. He falls through the hole and splats on the floor below. You see that the hole leads into some kind of warehouse. A piece of paper falls from his pocket befor he falls.>
				playwav <laser2.wav>
				hide <scientist>
				create exit down <lab scientist fight; warehouse>
				show <paper> } else {
				msg <You shoot the scientist but he just kills you with his uzi!>
				set numeric <health; 0> }
		}
	end define

	define object <vial>
		look <It's a vial.>
		take
		prefix <a glass>
		displaytype <Object>
		article <it>
		gender <it>
		drop nowhere <You might need it.>
	end define

	define object <paper>
		take
		prefix <a piece of>
		displaytype <Object>
		article <it>
		gender <it>
		hidden
		use <pen> {
			msg <You draw a crop circle on the piece of paper.>
			hide <paper>
			show <paper2>
			give <paper2>
		}
	end define

	define object <paper2>
		alias <paper>
		prefix <a piece of>
		displaytype <Object>
		article <it>
		gender <it>
		hidden
		properties <examine=A crop circle has been drawn on it.>
	end define

end define

define room <warehouse>
	indescription <You are in a:>
	description <This is a full warehouse. Barrels are stacked against the walls. An elevator is here.>

	define object <barrels>
		look <There are barrels everywhere.>
		displaytype <Object>
		article <it>
		gender <it>
		use <axe> {
			msg <You smash open the barrels and find a contains of poison! A pen also falls out.>
			hide <barrels>
			show <container>
			show <pen>
		}
	end define

	define object <elevatorthing>
		alias <elevator>
		look <It's an elevator.>
		prefix <an>
		displaytype <Object>
		article <it>
		gender <it>
		use <paper2> {
			msg <You swipe the paper and the elevator's doors slide open.>
			hide <elevatorthing>
			create exit <warehouse; elevator>
		}
		properties <examine=It requires a pass card.>
	end define

	define object <container>
		look <This container is full of poison!>
		prefix <a>
		suffix <full of poison>
		displaytype <Object>
		article <it>
		gender <it>
		hidden
		container
		open msg <That isn't the best idea in ages.>
		properties <examine=There might be some on the outside to so I wouldn't go near it. You can see though that there is a symbol of a crop circle on it.>
	end define

	define object <pen>
		take
		prefix <a>
		displaytype <Object>
		article <it>
		gender <it>
		hidden
	end define

end define

define room <elevatorroom>
	alias <elevator>
	indescription <You are in a:>
	out <clearing>
	description <This is an elevator. There is a key hole on one wall. Loads of weapons are on racks around the walls of this huge elevator.>

	define object <keyhole>
		look <It's a small keyhole.>
		prefix <a small>
		displaytype <Object>
		article <it>
		gender <it>
	end define

end define

define room <elevator>
	indescription <You are in a:>
	out <warehouse>
	description <This is a cramped elevator. A keypad is here! You probably have to find the code obviously!>
	command <use keypad> {
		msg <Enter your code.>
		enter <keypad>
		if ( #keypad# = mut ) then {
			msg <The elevator rises. You find yourself on the roof of the warehouse!>
			goto <warehouse roof> } else msg <Nothing happens.>
	}

	define object <keypad>
		look <It's a keypad with the words "enter code" written abuv it.>
		prefix <a>
		displaytype <Object>
		article <it>
		gender <it>
	end define

end define

define room <warehouse roof>
	indescription <You are in a:>
	description {
		msg <You step out onto the roof of the warehouse. You see a huge contraption before you. As you study this you suddenly here a sound from behind you. You whip round and see an alien holding a laser uzi and a laser pistol and a laser smg and 555 laser grenades on a minny spaceship floating next to him. He points it at you.|n "'step away from the motorgenerator" the alien says in a robot voice holding a translator.|nY9ou have no choice but to walk away from the contraption.|n "You will get in the spaceship and will have your weapons removed" the alien says.|nYou climb into the spaceship full of explosives. Your weapons are taken (including your axe).|n "You will now be left to die" the alien says befor slamming the door and pushing a button. The spaceship blasts into orbit arround the earth!>
		wait <PRESS A KEY TO SEE WHAT HAPPENS!>
		goto <orbit>
		move <smg; elevatorroom>
		move <axe; elevatorroom>
		move <laser pistol; elevatorroom>
	}
end define

define room <orbit>
	alias <spaceship>
	indescription <You are in a:>
	description <You are stuck on a spaceship full of explosives in orbit around the earth! There is loads of equipment here but you can't destroy any of it.>

	define object <equipment>
		look <It's the spaceship's equipment.>
		displaytype <Object>
		article <it>
		gender <it>
		use <laser grenade> {
			msg <You throw the grenade at the equipment. It explodes kill ing you instantly!>
			playerlose
		}
		use <hammer> {
			msg <You bash up the equipment revealing a space suit and a plug socket.>
			hide <equipment>
			show <space suit>
			show <socket>
		}
		action <examine> {
			if exists <hammer> then msg <There is nothing special about it.> else {
				msg <You look through the equipment and find a hammer.>
				show <hammer> }
		}
	end define

	define object <laser grenades>
		look <It's a laser grenade!>
		prefix <a>
		displaytype <Object>
		article <it>
		gender <it>
		drop nowhere <You aren't an idiot!>
		action <take> msg <You should try "take laser grenade" not take all of them!>
	end define

	define object <laser grenade>
		look <A laser grenade.>
		take
		prefix <a>
		displaytype <Object>
		article <it>
		gender <it>
		invisible
		drop nowhere <You aren't an idiot!>
	end define

	define object <hammer>
		take
		prefix <a>
		displaytype <Object>
		article <it>
		gender <it>
		hidden
	end define

	define object <space suit>
		look <Just a space suit.~>
		take <You pick up the space suit.>
		prefix <a>
		displaytype <Object>
		article <it>
		gender <it>
		drop nowhere <You might need this.>
		properties <not unzipped>
		action <wear> msg <You need to find an oxygen tank first.>
		action <unzip> {
			msg <You unzip the space suit.>
			set string <space suit; unzipped>
		}
		action <examine> {
			if ( #space suit# = unzipped ) then {
				msg <You find a scart lead and a parachute.>
				show <scart lead>
				show <parachute> } else msg <The suit is zipped up.>
		}
	end define

	define object <hatch>
		look <It's the only thing stopping you from being sucked out into space.>
		prefix <a>
		displaytype <Object>
		article <it>
		gender <it>
		container
		open msg <That isn't a great idea and even if you were dumb it's locked.>
	end define

	define object <socket>
		displaytype <Object>
		article <it>
		gender <it>
		hidden
		use <scart lead> {
			msg <You plug in the scart lead. Suddenly the spaceship dives towards earth! 100000 feet abuv the earth the hatch slides open and you fall to your doom!>
			wait <PRESS A KEY TO CONTINUE!>
			goto <sky>
		}
	end define

	define object <scart lead>
		take
		displaytype <Object>
		article <it>
		gender <it>
		hidden
	end define

	define object <parachute>
		look <It's a parachute.>
		take
		prefix <a>
		displaytype <Object>
		article <it>
		gender <it>
		hidden
		action <wear> {
			if not ( #parachute# = worn ) then {
				msg <You wear the parachute.>
				property <parachute; alias parachute (worn)>
				set string <parachute; worn> } else msg <You're already wearing it!>
		}
		action <unwear> {
			if ( #parachute# = worn ) then {
				msg <You take off the parachute.>
				property <parachute; alias parachute> } else msg <You aren't wearing the parachute.>
		}
	end define

end define

define room <dump>
	indescription <You are in a:>
	south <town>
	description <This is a dump. There is a huge pile of junk against all sides of the dump. Who knows what you couldn't find here?>

	define object <junk>
		look <It's a huge pile of junk.>
		prefix <a pile of>
		displaytype <Object>
		article <it>
		gender <it>
		action <search> {
			msg <You search through the junk and find a suitcase!>
			hide <junk>
			show <suitcase>
			show <junk2>
		}
	end define

	define object <suitcase>
		look <It's a black suitcase.>
		take
		prefix <a>
		displaytype <Object>
		article <it>
		gender <it>
		hidden
		drop everywhere <You place it on the ground.>
		container
		open {
			if ask <Do you want to try to open the case?> then {
				msg <Type the code now.>
				enter <case>
				if ( #case# = 1873 ) then {
					msg <There is a click.>
					hide <suitcase>
					show <suitcase2> } else msg <Nothing happens.> }
		}
		properties <examine=You need a code to open it.>
	end define

	define object <dead rat>
		look <It's a rotting corpse of a dead rat.>
		take
		prefix <a>
		displaytype <Object>
		article <it>
		gender <it>
		hidden
		properties <examine=It smells disgusting!>
	end define

	define object <jug>
		look <This jug is filthy.>
		take
		prefix <a filthy>
		displaytype <Object>
		article <it>
		gender <it>
		hidden
		properties <examine=There is dirt all over it! Written on the side is "noe hegit veens herte.">
	end define

	define object <junk2>
		alias <junk>
		look <It's a huge pile of junk.>
		prefix <a pile of>
		displaytype <Object>
		article <it>
		gender <it>
		hidden
		action <search> {
			msg <You search through the junk and find a dead rat.>
			hide <junk2>
			show <dead rat>
			show <junk3>
		}
	end define

	define object <junk3>
		alias <junk>
		look <It's a huge pile of junk.>
		prefix <a pile of>
		displaytype <Object>
		article <it>
		gender <it>
		hidden
		action <search> {
			msg <You search through the junk and find a jug.>
			hide <junk3>
			show <jug>
			show <junk4>
		}
	end define

	define object <junk4>
		alias <junk>
		look <It's a huge pile of junk.>
		prefix <a pile of>
		displaytype <Object>
		article <it>
		gender <it>
		hidden
		properties <search=You search through the junk and find nothing.>
	end define

	define object <suitcase2>
		alias <suitcase>
		look <It's a black suitcase.>
		take
		prefix <a>
		displaytype <Object>
		article <it>
		gender <it>
		hidden
		drop everywhere <You place it on the ground.>
		container
		open <You open the suitcase.>
		close <You close the suitcase.>
		add
		remove
		properties <examine=It's unlocked.>
	end define

	define object <note>
		look <It's a note.>
		take
		prefix <a>
		displaytype <Object>
		article <it>
		gender <it>
		parent <suitcase2>
		hidden
		drop nowhere <This is important.>
		properties <read=It reads:|n "The aliens are going to kill me! Help! I did what thety said or what they brainwashed me into doing! Come to the sahara desert and dig near the middle. Enter the cell and I'll tell you how to stop them. I'm dying out here!">
	end define

	define object <map>
		look <It's a map.>
		take
		prefix <a>
		displaytype <Object>
		article <it>
		gender <it>
		parent <suitcase2>
		hidden
		use {
			if ( #quest.currentroom# = sahara desert ) then {
				msg <You follow the map. The bus left you serprisingly near your destination. You start digging with your hands and after about 5 hours you come on a cell. You enter the room.>
				goto <desert cell> } else msg <You aren't in the right place.>
		}
		drop nowhere <This is important.>
		properties <examine=It's a map of the sara desert.>
	end define

end define

define room <sky>
	script {
		if ( #parachute# = worn ) then {
			msg <The parachute opens and you slow down as you hurtal towards your splatty end. However you think you will still die!>
			wait <PRESS A KEY TO SEE WHAT HAPPENS!>
			msg <You hit something soft. You have enough time to realise it's a pile of junk and you are in a dump befor the force of the fall knocks you out!>
			wait <PRESS A KEY TO SEE WHAT HAPPENS!>
			msg <You wake up in a pile of junk. You pull yourself out.>
			goto <dump> } else {
			msg <You splat on the ground!>
			set numeric <health; 0> }
	}
	description <You are falling through the sky towards your doom! Aeroplanes are flying past you!>
end define

define room <town>
	indescription <You are in a:>
	north <dump>
	description <This is a small town. To the north is the dump. A coach is here with "sahara" written on the side of it.>
	command <get on bus> {
		if ask <Do you want to pay 4 gold dollars to take a bus ride?> then {
			msg <You get on the bus. After 4 hours you reach the sahara desert!>
			goto <sahara desert>
			dec <money; 4> }
	}

	define object <bus>
		look <It's a bus with "sahara" written on the side of it.>
		prefix <a>
		displaytype <Object>
		article <it>
		gender <it>
		properties <examine=Just get on it.;examine=Just get on it.>
	end define

	define object <chips>
		alias <chips>
		look <It's a bag of chips.>
		take
		prefix <a bag of>
		displaytype <Object>
		article <it>
		gender <it>
	end define

end define

define room <sahara desert>
	indescription <You are in a:>
	description <This is the sahara desert. The coach has left you to die out here!>
end define

define room <desert cell>
	alias <cell>
	indescription <You are in a:>
	description <This is a cell. There is a scientist leaning against a wall dying of starvation.>

	define object <scientist2>
		alias <scientist>
		look <She's a scientist.>
		speak <"Food. I need food. I'll tell you everything... Food!">
		prefix <a>
		displaytype <Character>
		article <her>
		gender <she>
		give <chips> {
			displaytext <scientist>
			hide <chips>
			goto <desert>
		}
	end define

end define

define room <desert>
	alias <sahara desert>
	indescription <You are in a:>
	script {
		give <vial1>
		give <vial2>
		timeron <cube>
	}
	description <This is the sahara desert. A huge cube is hovering over you firing lasers at you!>

	define object <vial1>
		alias <vial>
		look <It's a vial full of assid.>
		take
		prefix <a>
		suffix <of assid>
		displaytype <Object>
		article <it>
		gender <it>
		drop nowhere <Don't be dumb!>
	end define

	define object <vial2>
		alias <vial>
		look <It's a vial full of assid.>
		take
		prefix <a>
		suffix <full of assid>
		displaytype <Object>
		article <it>
		gender <it>
		drop nowhere <Don't be dumb!>
	end define

	define object <cube>
		look <It's a huge cube hovering abuv you firing lasers at you!>
		prefix <a>
		displaytype <Object>
		article <it>
		gender <it>
		use <vial1> {
			set numeric <random; $rand(1; 2)$>
			if ( %random% = 1 ) then {
				msg <The vial hits the cube! The assid eats through half of it.>
				playwav <smash.wav>
				hide <vial1>
				dec <cube health; 5> } else msg <The vial misses the cube but you catch it.>
			if ( %cube health% <= 0 ) then do <cube destroyed>
		}
		use <vial2> {
			set numeric <random; $rand(1; 2)$>
			if ( %random% = 1 ) then {
				msg <The vial hits the cube. The assid eats through half of it!>
				playwav <smash.wav>
				hide <vial2>
				dec <cube health; 5> }
			if ( %cube health% <= 0 ) then do <cube destroyed>
		}
		use <smg> {
			msg <You shoot the cube but it doesn't have any effect.>
			playwav <smg short burst.wav>
		}
		use <laser pistol> {
			msg <You shoot the cube but the laser doesn't have any effect.>
			playwav <laser2.wav>
		}
	end define

	define object <dumbville chip>
		alias <security chip>
		look <It's a security chip.It's a security chip.>
		take
		prefix <a>
		displaytype <Object>
		article <it>
		gender <it>
		hidden
		drop nowhere <You might need it.>
	end define

end define

define room <dumbville>
	indescription <You are in a:>
	north if flag <gates> then goto <mayor path> else msg <The gates are locked.>
	description <This is the dumb town of dumbville. People are falling over because they are to dumb to walk. A cat is wedged in a manhole and the people are to dumb to rescue it... oh wait it's dead. People are walking around like mindless zombies. The people have even dropped all their jewelry all over the floor and thieves are nicking it. To the north are a pair of impressive irong gates leading to a path.>
	command <teleport> goto <teleport stand>

	define object <jewelry>
		look <It's loads of jewelry!>
		prefix <loads of>
		displaytype <Object>
		article <it>
		gender <it>
		action <take> msg <You're not a thief.>
		action <examine> {
			if exists <skull> then msg <It's probably worth a fortune!> else {
				msg <You look through the jewelry and find a skull!>
				show <skull> }
		}
	end define

	define object <dead cat>
		look <This cat's corpse is trapped in a manhole. The manhole has squeezed it's guts so it's liver is sticking out of it's mouth and blood is flowing everywhere!>
		prefix <a>
		displaytype <Object>
		article <it>
		gender <it>
		properties <examine=It's got something carved into it's back. The carving reads "doctor kill.">
		action <take> msg <No thanks.>
	end define

	define object <skull>
		take
		displaytype <Object>
		article <it>
		gender <it>
		hidden
		drop nowhere <You might need it.>
	end define

	define object <gates>
		look <It's a pair of iron gates.>
		prefix <a pair of>
		displaytype <Object>
		article <it>
		gender <it>
		use <remote> {
			if flag <gates> then msg <You've already done that.> else {
				msg <You aim the remote at the gates and push the open button. They swing open.>
				flag on <gates> }
		}
	end define

end define

define room <desert cell2>
	indescription <You are in a:>
	description {
		if got <dumbville chip> then {
			msg <You walk back into the cell. You follow the map with the scientist until you reach a bus stop. You get on a bus and drive back to your hometown.>
			goto <hometown> } else {
			msg <You need to go back and find something first.>
			goto <desert> }
	}
end define

define room <ice forest camp>
	indescription <You are in a:>
	south <ice forest>
	description {
		msg <You enter a small camp. Before you can walk through it a soldier grabs you.|n "You have trespassed into are camp. Now you will pay!">
		wait <PRESS A KEY TO SEE WHAT HAPPENS!>
		msg <"If you have a skull though you can pass">
		if got <skull> then {
			msg <You are thrown through a gate!>
			goto <clearing> } else {
			msg <"You don't have a skull! Time to die!"|nHe pulls out a sword and stabs you! He flings you onto a fire and eats you!>
			set numeric <health; 0> }
	}
end define

define room <clearing>
	south {
		msg <You are escorted back through the camp.>
		goto <ice forest>
	}
	place <elevatorroom> {
		msg <You head into an elevator.>
		goto <elevatorroom>
	}
	description <This is a clearing. A small tree is in the middle of it. You also see an elevator in the middle of it!>

	define object <tree>
		look <It's a small tree.>
		prefix <a>
		displaytype <Object>
		article <it>
		gender <it>
		use <axe> {
			msg <You chop down the tree.>
			hide <tree>
			show <wood pile>
		}
		action <climb> msg <You can't you have to save the world first.>
	end define

	define object <wood pile>
		look <It's a huge pile of wood.>
		prefix <a>
		displaytype <Object>
		article <it>
		gender <it>
		hidden
		action <search> {
			if exists <sack> then msg <You search the wood pile but find nothing else.> else {
				msg <You search the wood pile and find a sack.>
				show <sack> }
		}
	end define

	define object <sack>
		look <It's a black sack.>
		take
		prefix <a black>
		displaytype <Object>
		article <it>
		gender <it>
		hidden
		container
		open <You open the sack.>
		close <You close the sack.>
		add
		remove
	end define

	define object <triangle>
		look <It's a trangle made out of wood.>
		take
		prefix <a>
		suffix <made out of wood>
		displaytype <Object>
		article <it>
		gender <it>
		parent <sack>
		drop nowhere <You might need it.>
	end define

	define object <remote>
		look <It's a black remote.>
		take
		prefix <a>
		displaytype <Object>
		article <it>
		gender <it>
		parent <sack>
		use msg <>
		drop nowhere <You might need it.>
	end define

	define object <clay>
		look <It's just some clay.>
		take
		displaytype <Object>
		article <it>
		gender <it>
		drop nowhere <You might need this.>
		action <examine> msg <It is in the form of a #clayshape#.>
	end define

end define

define room <mayor path>
	alias <path>
	north msg <The front door is locked.>
	south <dumbville>
	east <mayor pond>
	west <mayor lawn>
	script {
		if flag <bench> and flag <fountain> or flag <door> then {
			msg <You hear a click.>
			hide <door>
			show <door2> } else msg <You hear a beep.>
	}
	description <You are walking down a path. To the north is the front door of a house. There is a huge pond to the east.>

	define object <door>
		look <It's the front door of a house.>
		prefix <a>
		displaytype <Object>
		article <it>
		gender <it>
		use <triangle> {
			msg <You fit the triangle into the hole.>
			hide <triangle>
			flag on <door>
			action <door; examine> exec <look at door>
		}
		use <triangle2> {
			msg <You fit the triangle into the hole in the door.>
			hide <triangle2>
			flag on <door>
			action <door; examine> exec <look door>
		}
		container
		open msg <It's locked.>
		properties <examine=There is a triangular hole in it.;examine=There is a triangular hole in it.>
	end define

	define object <door2>
		alias <door>
		look <It's the front door of a house.>
		prefix <a>
		displaytype <Object>
		article <it>
		gender <it>
		hidden
		container
		open {
			msg <You open the door. It falls off it's hinges!>
			hide <door2>
			create exit north <mayor path; oracle room>
		}
	end define

end define

define room <mayor pond>
	alias <pond>
	west <mayor path>
	description <You are standing beside a pond. You don't know why there is a pond in the front yard! A bench is next to the pond.>

	define object <pond>
		look <It's a large pond.>
		prefix <a>
		displaytype <Object>
		article <it>
		gender <it>
		action <examine> {
			msg <There is a duck flying over it.>
			show <duck>
			action <pond; examine> exec <look at pond>
		}
	end define

	define object <bench2>
		alias <bench>
		look <It's a long bench.>
		prefix <a>
		displaytype <Object>
		article <it>
		gender <it>
		use <triangle2> {
			msg <You fit the triangle into the hole in the bench.>
			hide <triangle2>
			action <bench; examine> exec <look bench>
			flag on <bench>
		}
		use <triangle> {
			msg <You fit the triangle into the hole in the bench.>
			hide <triangle>
			action <bench; examine> exec <look bench>
			flag on <bench>
		}
		properties <examine=;examine=>
	end define

	define object <duck>
		prefix <a>
		displaytype <Object>
		article <it>
		gender <it>
		hidden
		use <smg> {
			msg <You shoot the duck. A pair of glasses fall from it's back and land next to the pond.>
			playwav <smg single shot.wav>
			hide <duck>
			show <glasses>
		}
	end define

	define object <glasses>
		look <It's a pair of glasses.>
		take
		prefix <a pair of>
		displaytype <Object>
		article <them>
		gender <they>
		hidden
		drop nowhere <You might need them.>
		action <wear> msg <You don't need glasses.>
	end define

end define

define room <mayor lawn>
	alias <lawn>
	east <mayor path>
	description <This is a lawn. Nothing special here.>

	define object <fountain>
		look <This fountain is large. It stands in the middle of the lawn.>
		prefix <a>
		displaytype <Object>
		article <it>
		gender <it>
		use <clay> {
			if ( #clayshape# = triangle ) then {
				msg <You fit the clay into the hole.>
				hide <clay>
				action <fountain; examine> exec <look fountain>
				flag on <fountain> } else msg <You need to do something first.>
		}
		properties <examine=There's a hole in it.;examine=There's a hole in it.>
	end define

end define

define room <oracle room>
	south <mayor path>
	description <This is a throne room. A figure sits on a throne at the northern end.>

	define object <oracle>
		look <The oracle is sitting on a huge throne.>
		speak {
			displaytext <oracle>
			show <darkness chip>
			give <darkness chip>
			action <oracle; speak> msg <"Quik kill the alien chief!">
		}
		prefix <the>
		displaytype <Character>
		article <her>
		gender <she>
	end define

	define object <darkness chip>
		alias <security chip>
		look <It's a security chip.>
		take
		prefix <a>
		displaytype <Object>
		article <it>
		gender <it>
		hidden
		drop nowhere <You might need this.>
	end define

end define

define room <darkness>
	alias <darkness>
	indescription <You are in a:>
	north {
		msg <You stumble forward through the darkness. Suddenly you find yourself in a huge arena.|n "Well well well. Finally you've come now die!">
		background <white>
		panes on
		goto <final fight>
	}
	script {
		background <black>
		panes off
	}
	description <You are in total darkness. You can't see anything!>
	command <compass> msg <You can't see anything.>
	command <objects> msg <You can't see anything.>
	command <places> msg <You can't see anything.>
	command <teleport> msg <You can't see anything.>
end define

define room <final fight>
	alias <arena>
	indescription <You are in a:>
	script {
		set numeric <chiefhealth; 100>
		set numeric <health; 100>
		msg <You are healed for some reason.>
	}
	description <You are in an arena! The chief of the aliens is shooting you!>
	afterturn {
		if ( %chiefhealth% <= 0 ) then goto <win> else {
			set numeric <random; $rand(1; 3)$>
			if ( %random% > 1 ) then {
				msg <The alien warlord's laser hits you hurting you for 10 damage!>
				dec <health; 10>
				playwav <cube gun.wav> } else {
				msg <The alien warlord's laser misses you!>
				playwav <cube gun.wav> } }
	}

	define object <warlord>
		look <It's the leader of the aliens. It's not a human so you don't have a clue if it's male or female.>
		speak msg <"I will kill you" the warlord yells.>
		prefix <the>
		displaytype <Object>
		article <it>
		gender <it>
		use <smg> {
			set numeric <random; $rand(1; 2)$>
			if ( %random% = 1 ) then {
				msg <You shoow the alien warlord!>
				dec <chiefhealth; 5> } else msg <Your bullet misses it!>
			playwav <smg single shot.wav>
		}
		use <laser pistol> {
			set numeric <random; $rand(1; 2)$>
			if ( %random% = 1 ) then {
				msg <Your laser hits the alien warlord hurting it for 10 damage!>
				playwav <laser2.wav>
				dec <chiefhealth; 10> } else {
				msg <Your laser misses the warlord!>
				playwav <laser2.wav> }
		}
	end define

end define

define room <win>
	description playerwin
end define

define procedure <operations room enemys>
	msg <As you enter the room enemys aim laser guns!>
	if got <flame thrower> then {
		msg <As they start firing you burn them. Ash falls down through a grate in the floor.>
		flag off <operations room enemys> } else {
		msg <The enemy's zap you until you die!>
		repeat until ( %health% <= 0 ) do <die operations room enemys> }
end define

define procedure <die operations room enemys>
	playwav <laser1.wav>
	dec <health; 5>
end define

define procedure <space suit>
	if ( #space suit# = unzipped ) then {
		if flag <cable undescovered> then {
			msg <You see a cable in the space suit.>
			show <scart lead>
			flag off <cable undescovered> } else msg <There is nothing else in the space suit.> } else msg <The space suit is zipped up.>
end define

define procedure <cube destroyed>
	msg <The cube explodes! You hurl yourself out of the way as it hits the ground! A security chip flies from the huge crator and lands in front of you.>
	hide <cube>
	show <dumbville chip>
	timeroff <cube>
	create exit south <desert; desert cell2>
end define

define timer <dynamite>
	interval <5>
	action {
		msg <The dynamite explodes!>
		if ( #quest.currentroom# = fields ) then {
			msg <Unfortunately you were near the dynamite and got killed.>
			playerlose } else {
			hide <spaceship>
			hide <dynamite2> }
		timeroff <dynamite>
	}
	disabled
end define

define timer <cube>
	interval <1>
	action {
		set numeric <random; $rand(1; 2)$>
		if ( %random% = 1 ) then {
			msg <A laser hits you!>
			dec <health; 10> } else msg <A laser misses you!>
		playwav <cube gun.wav>
	}
	disabled
end define

define timer <mayor door>
	interval <0>
	action {
		if flag <bench> and flag <door> and flag <fountain> then {
			msg <There is a click from the path.>
			hide <door>
			show <door2>
			timeroff <mayor door> }
	}
	enabled
end define

define text <intro>
The world was once peaceful. However an insane scientist decided to blow up most of america. The missile missed by miles and hit the antarctic! This, obviously, has caused a tiny problem. The problem is incresed by the fact aliens have been discovered in the middle of the earth and have started rising up! You are trying to stop them. It probably won't work.

PRESS A KEY TO START PLAYING!
|w
end define

define text <win>
The alien chief slumps to the ground dead! You quikly kick it into a coffin that had been meant for you. You slam the lid shut then leave the arena looking for some way to escape this place. You realise that this place doesn't have a teleporter. The only way out is the spaceship! You have no choice. You get in and push "launch." The spaceship explodes! Your unconcious form flies through the air and hits the ground. Hard!

PRESS A KEY TO SEE WHAT HAPPENS!
|w
You wake up in a hospital room.
"You have done extremely well. However we might have a tiny problem...

The corpse of the alien warlord has dissappeared. If that gets in the wrong hands or touches the ground..."
You jump out of bed your legs crumpling under you like dust!
"OOOOOOOOOOWWWWWWWWWW!!!!!!!!!!"
"Forgot to tell you don't try to move."

(to be continued)
end define

define text <lose>
|cr |s99 GAME OVER!
end define

define text <captured>
As you trudge along another ledge you see a zombie up ahead! You try to turn back but another zombie drags you under the water! You are dragged down a long tunnel and into a cell. The key is turned in the lock leaving you trapped!
end define

define text <scientist>
You give her the chips.
"I was just a normal scientist. My dad had been shot in the head by an assassin and I wasn't feeling to great about it. I was working in the lab when a huge cube hovered abuv the lab."
"Was the lab beneath bloodbath city?" you ask.
"It was. Anyway I called the police but a laser destroyed the connection. The cube seemed to descend then I was here. A vial did explode and it was the vial of assid and it damaged it. I remember blacking out then waking up here."
Suddenly you feel metal against the back of your neck and a robotic voice.
"Sorry to cut the description of all hour plans short but I'm afraid I'm going to have to kill you."

PRESS A KEY TO SEE WHAT HAPPENS!
|w
You are lead out onto a desert where a huge cube is hovering! Suddenly 2 vials fly through the air and land in front of you. You quikly pick them up.
end define

define text <oracle>
"I see you have arrived at last. You have to stop the aliens! They are going to destroy the world! Obviously! I have the chip to their location. Take this and destroy the alien chief. And whatever you do don't let the chief's blood touch the ground or the whole universe will explode!"
She hands you a security chip.
end define

define selection <teleport>
	info <Where will you teleport to?>
	choice <snowville> goto <snowville>
	choice <#heatville#> if ( #heatville# = locked ) then msg <That location is locked.> else goto <heatville>
	choice <#sleepville#> if ( #sleepville# = locked ) then msg <That location is locked.> else goto <sleepville>
	choice <#awakeville#> if ( #awakeville# = locked ) then msg <This location is locked.> else goto <awakeville>
	choice <#bloodbath city#> if ( #bloodbath city# = locked ) then msg <This location is locked.> else goto <bloodbath city>
	choice <#dumbville#> if ( #dumbville# = locked ) then msg <This location is locked.> else goto <dumbville>
	choice <#darkness#> if ( #darkness# = locked ) then msg <This location is locked.> else goto <darkness>
end define
define selection <guns select>
	info <"What type of gun do you want to buy?">
	choice <normal guns> choose <normal guns>
	choice <laser guns> choose <laser guns>
	choice <nothing> msg <You buy nothing.>
end define
define selection <normal guns>
	info <"Choose a gun.">
	choice <smg (20 gold dollars)> {
		if ( %money% > 20 ) then {
			if exists <smg> then msg <You already have an smg!> else {
				msg <"Here you go."|nHe hands you a new smg.>
				dec <money; 20>
				show <smg>
				give <smg> } } else msg <You don't have enough money to buy it.>
	}
	choice <buy nothing> msg <>
end define
define selection <laser guns>
	info <"What laser gun do you want?">
	choice <laser pistol (200 gold dollars)> {
		if ( %money% < 200 ) then msg <You don't have enough money to buy it.> else {
			if exists <laser pistol> then msg <You already have a laser pistol!> else {
				msg <You buy the laser pistol.>
				show <laser pistol>
				give <laser pistol>
				dec <money; 200> } }
	}
	choice <nothing> msg <You buy nothing.>
end define
define selection <guard>
	info <"I'll give you something for that flame thrower. What do you want?">
	choice <an uzi> msg <"Don't have it.">
	choice <10000000000000000 gold dollars> msg <"Don't have that much.">
	choice <the password for the computers in the operations room> {
		msg <"It is "bloodbath."|n|nYou give him the flame thrower. He runs away to torture someone.>
		hide <flame thrower>
		hide <guard>
	}
end define
define selection <computers1>
	info <What will you do?>
	choice <email> choose <computers email>
	choice <security> choose <computers security>
	choice <log off> msg <>
end define
define selection <computers email>
	info <What will you do?>
	choice <check inbox> {
		msg <You click on the inbox. You find an email!|n|nThe email reads:|n "Something's gone wrong! The experiment isn't working like it should do. The missile you ordered me to fire at america has missed and hit one of your biggest bases. Don't kill me!"|nPerson@bloodbath.com>
		choose <computers email>
	}
	choice <check outbox> {
		msg <There are 2 emails in the outbox.|n|nEmail 1 reads:|n "I have sent the data to you. Upload this data onto the missile's route. The co-ordinates are "17-23 23-29."|n|nMessage 2 reads:|n "I will be coming to kill you shortly.">
		choose <computers email>
	}
	choice <exit email> choose <computers1>
end define
define selection <computers security>
	info <What will you do?>
	choice <turn off security> {
		if ( #security# = off ) then msg <The security is already turned off.> else {
			msg <You shut down the security.>
			set string <security; off> }
	}
	choice <turn on security> {
		if ( #security# = on ) then msg <The security is already on.> else {
			msg <You turn on the security.>
			set string <security; on> }
	}
	choice <leave security> choose <computers1>
end define

